<?php 
require_once('../modelos/Banco.php');

$banco=new Banco();

$idbanco=isset($_POST["idbanco"])? limpiarCadena($_POST["idbanco"]):"";
$nombre=isset($_POST["nombre"])? limpiarCadena($_POST["nombre"]):"";
$estado=isset($_POST["estado"])? limpiarCadena($_POST["estado"]):"";

switch ($_GET["op"])
{
    case 'guardaryeditar':
      if(empty($idbanco))
      {
        $rspta=$banco->insertar($nombre,$estado);
        echo $rspta ? "Banco Registrado" : "Banco no se pudo registrar";
      }
      else {
          $rspta=$banco->editar($idbanco,$nombre,$estado);
          echo $rspta ? "Banco Actualizada" : "Banco no se pudo actualizar";
      }
    break;

    case 'mostrar':
      $rspta=$banco->mostrar($idbanco);
       //Codificar el resultado utilizando json
       echo json_encode($rspta);
    break;

    case 'eliminar':
      $rspta=$banco->eliminar($idbanco);
       //Codificar el resultado utilizando json
       echo json_encode($rspta);
    break;

    case 'listarbanco':
      $rspta=$banco->listarbanco();
      //Vamos a declarar un array
      $data=Array();
      while($reg=$rspta->fetch_object())
      {
        $estado = ($reg->estado == 1) 
            ? '<button class="btn btn-success btn-xs btn-flat">Activa</button>' 
            : '<button class="btn btn-danger btn-xs btn-flat">Inactiva</button>';
        $data[]=array(
          "0"=>$reg->nombre,
          "1"=>$estado,          
          "2"=>'<a href="create.php?idbanco=' . $reg->idbanco . '" class="btn btn-warning btn-xs btn-flat"><i class="fa fa-edit"></i></a>' .
               ' <button class="btn btn-danger btn-xs btn-flat" onclick="eliminar(' . $reg->idbanco . ')"><i class="fas fa-trash-alt"></i></button>'
        );
      }
      $results= array(
        "sEcho"=>1, //Informacion para el datatable
        "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
        "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
        "aaData"=>$data);
      echo json_encode($results);

    break;

    case 'selectbanco': 
      $rspta = $banco->selectbanco();
      if ($rspta) {
          while ($reg = $rspta->fetch_object()) {
              echo "<option value='" . htmlspecialchars($reg->idbanco, ENT_QUOTES, 'UTF-8') . "'>" . htmlspecialchars($reg->nombre, ENT_QUOTES, 'UTF-8') . "</option>";
          }
      } else {
          echo "<option value=''>No hay bancos disponibles</option>";
      }
      break;
}
?>