function init(){

      $("#form_voucher").on("submit", function(e) {
        enviarVoucher(e); // Llamar a la función para procesar el formulario
      });

      
      $.post("../../ajax/banco.php?op=selectbanco", function (r) {
    // Limpiar las opciones antes de agregar nuevas
        $("#idbanco").html('<option value="">Seleccione Banco</option>'); 

        // Agregar nuevas opciones
        $("#idbanco").append(r);
    });
}

  function traerContratos(idusuario) {
  $.post("../../ajax/contrato.php?op=selectContrato", { idusuario: idusuario }, function (r) {
    // Insertar las opciones
    $("#idcontrato").html('<option value="">Seleccione un Contrato</option>');
    $("#idcontrato").append(r);

    // Esperar a que el DOM actualice y seleccionar el primer contrato (si hay)
    setTimeout(() => {
      const firstOption = $("#idcontrato option").eq(1); // índice 1 porque 0 es "Seleccione un Contrato"
      if (firstOption.length) {
        $("#idcontrato").val(firstOption.val()); // establecer como seleccionado
        // Disparar manualmente el evento change para que se carguen los datos
        $("#idcontrato").trigger("change");
      }
    }, 100); // pequeño retraso para asegurar que el HTML se actualizó
  });
}

  function listarDeudas(idcontrato) {
    $.ajax({
      url: '../../ajax/pago.php?op=listar_deudas',
      type: 'GET',
      data: { idcontrato: idcontrato },
      dataType: 'json',
      success: function (response) {
        let html = `
          <div class="custom-table-header">
            <div class="custom-table-cell">PAGAR</div>
            <div class="custom-table-cell">VENCIMIENTO</div>
            <div class="custom-table-cell">TIPO PAGO</div>
            <div class="custom-table-cell">CARGO MENSUAL</div>
            <div class="custom-table-cell">ESTADO</div>
          </div>`;

        response.forEach((item, index) => {
          html += `
            <div class="custom-table-row">
              <div class="custom-table-cell" data-label="Pagar">
                <button class="btn btn-danger btn-sm" onclick="abrirModalPago('${item.idcuota}', '${item.idcontrato}', '${item.monto}')">
                  Pagar
                </button>
              </div>
              <div class="custom-table-cell" data-label="Vencimiento">
                <span class="badge bg-warning">Corte - ${item.vencimiento}</span>
              </div>
              <div class="custom-table-cell" data-label="Tipo Pago">${item.descripcion}</div>
              <div class="custom-table-cell" data-label="Cargo Mensual">S/ ${item.monto}</div>
              <div class="custom-table-cell" data-label="Estado">
                <span class="badge ${item.estado_cuota == '1' ? 'bg-danger' : 'bg-success'}">
                  <i class="bi ${item.estado_cuota == '1' ? 'bi-x-circle' : 'bi-check-circle'}"></i>
                  ${item.estado_cuota == '1' ? 'Pendiente' : 'Pagado'}
                </span>
              </div>
            </div>`;
        });

        $('#tabla-deudas').html(html);
      },
      error: function () {
        $('#tabla-deudas').html('<div class="text-danger">Error al cargar las deudas.</div>');
      }
    });
  }

  function listarRecibosPagados(idcontrato) {
    $.ajax({
      url: '../../ajax/pago.php?op=listar_recibos_pagados',
      type: 'GET',
      data: { idcontrato: idcontrato },
      dataType: 'json',
      success: function (response) {
        let html = `
          <div class="custom-table-header">
            <div class="custom-table-cell">SERVICIO/RECIBO</div>
            <div class="custom-table-cell">PAGADO EL</div>
            <div class="custom-table-cell">DETALLE DEL SERVICIO</div>
            <div class="custom-table-cell">N° DE RECIBO</div>
            <div class="custom-table-cell">CARGO MENSUAL</div>
          </div>`;

        const meses = [
          'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio',
          'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'
        ];

        response.forEach(item => {
           const url = `../voucherpago.php?idcuota=${item.idcuota}`; // Generar la URL correctamente
          const numeroMes = parseInt(item.mes, 10);
          const nombreMes = meses[numeroMes - 1] || 'Mes inválido';
          html += `
            <div class="custom-table-row">
              <div class="custom-table-cell" data-label="Servicio">
                Recibo ${nombreMes} /
                <a target="_blank" href="${url}" class="ms-2">
                  <button class="btn btn-sm btn-primary">
                     <i class="fa fa-download"></i>
                  </button>
                </a>
              </div>
              <div class="custom-table-cell" data-label="Pagado el">${item.fecha_pago}</div>
              <div class="custom-table-cell" data-label="Detalle">${item.descripcion ? item.descripcion : 'Migracion al nuevo sistema'}</div>
              <div class="custom-table-cell" data-label="Recibo">${item.nrorecibo}</div>
              <div class="custom-table-cell" data-label="Monto">S/ ${parseFloat(item.monto).toFixed(2)}</div>
            </div>`;
        });

        $('#contenedor-pagados').html(html);
      },
      error: function () {
        $('#contenedor-pagados').html('<p class="text-danger">No se pudo cargar la información.</p>');
      }
    });
  }
  function abrirModalPago(idcuota, idcontrato, monto) {
   document.getElementById('modal-idcuota').value = idcuota;
  document.getElementById('modal-idcontrato').value = idcontrato;
  document.getElementById('modal-monto').value = parseFloat(monto).toFixed(2);

  // Mostrar el modal
  new bootstrap.Modal(document.getElementById('modalPago')).show();
}
  const inputImagen = document.getElementById('imagen');
  const preview = document.getElementById('previewImagenPoste');

  preview.addEventListener('click', () => {
    inputImagen.click();
  });

  inputImagen.addEventListener('change', () => {
    const file = inputImagen.files[0];
    if (file) {
      const reader = new FileReader();
      reader.onload = function (e) {
        preview.src = e.target.result;
      };
      reader.readAsDataURL(file);
    }
  });


  const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

    function enviarVoucher(e) {
        e.preventDefault();

        const idbanco = $("#idbanco").val().trim();
        const operacion = $("#operacion").val().trim();
        const fecha = $("#fecha").val().trim();
        
        const imagenInput = document.getElementById("imagen");

         if (idbanco === "") {
          Swal.fire({
            icon: "warning",
            title: "Campo inválido",
            text: "Por favor, seleccione un banco.",
          });
          return;
        }
         if (operacion === "") {
          Swal.fire({
            icon: "warning",
            title: "Campo inválido",
            text: "Por favor, ingrese el nroperacion.",
          });
          return;
        }
         if (fecha === "") {
          Swal.fire({
            icon: "warning",
            title: "Campo inválido",
            text: "Por favor, ingrese la fecha de pago.",
          });
          return;
        }
         if (imagenInput.files.length === 0) {
            Swal.fire({
                icon: "warning",
                title: "Campo inválido",
                text: "Por favor, seleccione una imagen.",
            });
            return;
            }
       
        $("#btnGuardar").prop("disabled", true);
        var formData = new FormData($("#form_voucher")[0]);

        swalWithBootstrapButtons.fire({
            title: "¿Estás seguro?",
            text: "¿Deseas guardar los cambios realizados?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonText: "Sí, guardar",
            cancelButtonText: "No, cancelar",
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {

            // Mostrar precarga inmediatamente
            Swal.fire({
                title: "Subiendo imagen...",
                html: "Por favor, espera mientras se guarda la imagen.",
                allowOutsideClick: false,
                didOpen: () => {
                Swal.showLoading();
                }
            });

            $.ajax({
                url: "../../ajax/portal.php?op=enviarVoucher",
                type: "POST",
                data: formData,
                contentType: false,
                processData: false,
                success: function (respuesta) {
                    try {
                        var datos = JSON.parse(respuesta);

                        if (datos.status === "success") {
                        Swal.fire({
                            icon: "success",
                            title: "Voucher registrado",
                            text: "Se ha registrado correctamente. En unos minutos el personal validará el monto pagado. ¡Espere!",
                            timerProgressBar: true,
                            willClose: () => {
                            window.location.href = "pago.php";
                            }
                        });
                        } else if (datos.status === "existe") {
                        Swal.fire({
                            icon: "info",
                            title: "Voucher ya enviado",
                            text: "Ya existe un comprobante enviado para esta cuota. Espere validación del personal.",
                            timerProgressBar: true,
                            willClose: () => {
                            window.location.href = "pago.php";
                            }
                        });
                        } else {
                        Swal.fire({
                            icon: "error",
                            title: "Error",
                            text: datos.message,
                            timer: 3000,
                            timerProgressBar: true,
                            allowOutsideClick: false,
                            willClose: () => {
                            window.location.href = "pago.php";
                            }
                        });
                        }
                    } catch (error) {
                        console.error("Error parsing JSON:", error);
                        Swal.fire({
                        icon: "error",
                        title: "Error de respuesta",
                        text: "Respuesta inesperada del servidor.",
                        confirmButtonText: "Aceptar"
                        });
                        $("#btnGuardar").prop("disabled", false);
                    }
                    },
                error: function () {
                Swal.fire({
                    icon: "error",
                    title: "Error",
                    text: "Hubo un problema con la solicitud. Intente nuevamente.",
                    confirmButtonText: "Aceptar"
                });
                $("#btnGuardar").prop("disabled", false);
                }
            });
            } else {
            $("#btnGuardar").prop("disabled", false);
            }
        });
    }

   


init();