function init(){

      $("#formularioDatos").on("submit", function(e) {
        enviarDatos(e); // Llamar a la función para procesar el formulario
      });

}

  const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

    function enviarDatos(e) {
        e.preventDefault();

        $("#btnGuardar").prop("disabled", true);
        var formData = new FormData($("#formularioDatos")[0]);

        swalWithBootstrapButtons.fire({
            title: "¿Estás seguro?",
            text: "¿Deseas guardar los cambios realizados?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonText: "Sí, guardar",
            cancelButtonText: "No, cancelar",
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {

            // Mostrar precarga inmediatamente
            Swal.fire({
                title: "Actualizando datos...",
                html: "Por favor, espera mientras se guarda los datos.",
                allowOutsideClick: false,
                didOpen: () => {
                Swal.showLoading();
                }
            });

            $.ajax({
                url: "../../ajax/persona.php?op=actualizar_datos",
                type: "POST",
                data: formData,
                contentType: false,
                processData: false,
                success: function (respuesta) {
                    try {
                        var datos = JSON.parse(respuesta);

                        if (datos.status === "success") {
                        Swal.fire({
                            icon: "success",
                            title: "Datos registrado",
                            text: "Datos actualizados correctamente!!",
                            timerProgressBar: true,
                            willClose: () => {
                            window.location.href = "dato.php";
                            }
                        });
                        } else {
                        Swal.fire({
                            icon: "error",
                            title: "Error",
                            text: datos.message,
                            timer: 3000,
                            timerProgressBar: true,
                            allowOutsideClick: false,
                            willClose: () => {
                            window.location.href = "pago.php";
                            }
                        });
                        }
                    } catch (error) {
                        console.error("Error parsing JSON:", error);
                        Swal.fire({
                        icon: "error",
                        title: "Error de respuesta",
                        text: "Respuesta inesperada del servidor.",
                        confirmButtonText: "Aceptar"
                        });
                        $("#btnGuardar").prop("disabled", false);
                    }
                    },
                error: function () {
                Swal.fire({
                    icon: "error",
                    title: "Error",
                    text: "Hubo un problema con la solicitud. Intente nuevamente.",
                    confirmButtonText: "Aceptar"
                });
                $("#btnGuardar").prop("disabled", false);
                }
            });
            } else {
            $("#btnGuardar").prop("disabled", false);
            }
        });
    }

init();