function init(){

    $("#clienteForm").on("submit", function(e) {
        validarCliente(e); // Llamar a la función para procesar el formulario
      });

      $("#form_voucher").on("submit", function(e) {
        enviarVoucher(e); // Llamar a la función para procesar el formulario
      });


      $.post("../ajax/banco.php?op=selectbanco", function(r){
      if ($.fn.select2 && $('#idbanco').data('select2')) {
        $('#idbanco').select2('destroy');
      }
         // Limpiar las opciones antes de agregar las nuevas
         $("#idbanco").html('<option value="">Seleccione Banco</option>'); 
         // Actualizar el contenido del select con las opciones de producto
         $("#idbanco").append(r);
    
      // Inicializar Select2 nuevamente
      $('#idbanco').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione un banco',
        allowClear: true,
      });
    });
}

function validarCliente(e) {
    e.preventDefault(); // Evitar acción por defecto

    const btnEnviar = $("#btnEnviar");
    btnEnviar.prop("disabled", true); // Deshabilitar para evitar doble clic

    const numero_dni = $("#numero_dni").val().trim();

    // Validación en blanco
    if (numero_dni === "") {
        Swal.fire({
            icon: "warning",
            title: "Campo vacío",
            text: "Por favor, ingresa un número de DNI/RUC.",
        });
        btnEnviar.prop("disabled", false);
        return;
    }

    // Validar existencia en la base de datos
    $.ajax({
        url: "../ajax/portal.php?op=validarNroDni&id=" + numero_dni,
        type: "GET",
        dataType: "json",
        success: function (response) {
            if (response.exists) {
                // Si existe, redireccionar (ajusta la URL a donde necesites ir)
                redirigirConPost(numero_dni);
            } else {
                // Si no existe, mostrar mensaje de error
                Swal.fire({
                    icon: "error",
                    title: "No encontrado",
                    text: "El número de DNI no cuenta con nuestro servicio.",
                });
                btnEnviar.prop("disabled", false);
            }
        },
        error: function () {
            Swal.fire({
                icon: "error",
                title: "Error",
                text: "Hubo un problema al validar el número de DNI. Intenta nuevamente.",
            });
            btnEnviar.prop("disabled", false);
        }
    });
}

function redirigirConPost(numero_dni) {
    const form = document.createElement('form');
    form.method = 'GET';
    form.action = 'consultacuenta.php';

    const input = document.createElement('input');
    input.type = 'hidden';
    input.name = 'numero_dni';
    input.value = numero_dni;

    form.appendChild(input);
    document.body.appendChild(form);
    form.submit(); // redirecciona enviando el valor sin mostrarlo en la URL
}


 function configureLoadingScreen(screen){
    $(document)
         .ajaxStart(function () {
             screen.fadeIn();
         })
        .ajaxStop(function () {
           screen.fadeOut();
         });
 }

 const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

    function enviarVoucher(e) {
        e.preventDefault();
        $("#btnGuardar").prop("disabled", true);
        var formData = new FormData($("#form_voucher")[0]);

        swalWithBootstrapButtons.fire({
            title: "¿Estás seguro?",
            text: "¿Deseas guardar los cambios realizados?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonText: "Sí, guardar",
            cancelButtonText: "No, cancelar",
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {

            // Mostrar precarga inmediatamente
            Swal.fire({
                title: "Subiendo imagen...",
                html: "Por favor, espera mientras se guarda la imagen.",
                allowOutsideClick: false,
                didOpen: () => {
                Swal.showLoading();
                }
            });

            $.ajax({
                url: "../ajax/portal.php?op=enviarVoucher",
                type: "POST",
                data: formData,
                contentType: false,
                processData: false,
                success: function (respuesta) {
                try {
                    var datos = JSON.parse(respuesta);

                    if (datos.status === "success") {
                    // Cerrar la precarga anterior y mostrar una confirmación antes de redirigir
                    Swal.fire({
                        icon: "success",
                        title: "Voucher registrado",
                        text: "Se ha registrado correctamente.",
                        timer: 2000,
                        timerProgressBar: true,
                        willClose: () => {
                         window.close(); // Esto solo funciona si la ventana fue abierta con window.open
                        }
                    });
                    } else {
                    Swal.fire({
                        icon: "error",
                        title: "Error",
                        text: datos.message,
                        timer: 3000,
                        timerProgressBar: true,
                        allowOutsideClick: false,
                        willClose: () => {
                        $("#btnGuardar").prop("disabled", false);
                        }
                    });
                    }
                } catch (error) {
                    console.error("Error parsing JSON:", error);
                    Swal.fire({
                    icon: "error",
                    title: "Error de respuesta",
                    text: "Respuesta inesperada del servidor.",
                    confirmButtonText: "Aceptar"
                    });
                    $("#btnGuardar").prop("disabled", false);
                }
                },
                error: function () {
                Swal.fire({
                    icon: "error",
                    title: "Error",
                    text: "Hubo un problema con la solicitud. Intente nuevamente.",
                    confirmButtonText: "Aceptar"
                });
                $("#btnGuardar").prop("disabled", false);
                }
            });
            } else {
            $("#btnGuardar").prop("disabled", false);
            }
        });
    }


    $(document).ready(function() {
    $('#btnguardar').on('click', function(event) {
        event.preventDefault();
        const numero_whasp = $("#numerow").val().trim();
        // Validación: no vacío y exactamente 9 dígitos numéricos
        if (numero_whasp === "" || numero_whasp.length !== 9 || !/^\d{9}$/.test(numero_whasp)) {
            Swal.fire({
                icon: "warning",
                title: "Campo inválido",
                text: "Por favor, ingresa un número de 9 dígitos.",
            });
            return; // Detener ejecución
        }
        // Mostrar pantalla de carga si tienes esa función activa
        var screen = $('#loader');
        configureLoadingScreen(screen);
        // Enviar datos por AJAX
        $.ajax({
            url: '../view/actualizarcliente.php',
            method: 'POST',
            data: $('#insert_formulario').serialize(),
            success: function(data) {
                if (data.trim() === "success") {
                    Swal.fire({
                        icon: "success",
                        title: "¡BIEN!",
                        text: "¡Datos actualizados correctamente!",
                        confirmButtonText: "Cerrar"
                    });
                } else {
                    Swal.fire({
                        icon: "error",
                        title: "Error",
                        text: "Ocurrió un error, por favor intenta nuevamente.",
                        confirmButtonText: "Cerrar"
                    });
                }
            },
            error: function(xhr, status, error) {
                Swal.fire({
                    icon: "error",
                    title: "Error AJAX",
                    text: "No se pudo contactar con el servidor.",
                    confirmButtonText: "Cerrar"
                });
            }
        });
    });
});

function obtenerUbicacion(callback) {
  if (!navigator.geolocation) {
    Swal.fire({
      icon: "error",
      title: "Navegador incompatible",
      text: "Tu navegador no soporta geolocalización.",
    });
    callback(); // continuar sin ubicación
    return;
  }

  navigator.geolocation.getCurrentPosition(
    async function (position) {
      const lat = position.coords.latitude;
      const lon = position.coords.longitude;

      $("#latitud").val(lat);
      $("#longitud").val(lon);

       // Usar Google Maps Geocoding API
      const apiKey = 'AIzaSyBQLjBXPoSFnn0NSj--qoqQUtH2oSlgboA'; // tu API key válida
      const url = `https://maps.googleapis.com/maps/api/geocode/json?latlng=${lat},${lon}&key=${apiKey}`;


      try {
        const response = await fetch(url);
        const data = await response.json();

        if (data.status === "OK" && data.results.length > 0) {
          const direccion = data.results[1].formatted_address;
          $("#direccion").val(direccion);
        } else {
          console.warn("No se pudo obtener la dirección");
          $("#direccion").val("");
        }
      } catch (e) {
        console.error("Error al consultar la dirección:", e);
        $("#direccion").val("");
      }

      callback(); // continuar después de obtener todo
    },
    function (error) {
      let mensaje = "No se pudo obtener tu ubicación.";

      if (error.code === error.PERMISSION_DENIED) {
        mensaje = "Debes permitir el acceso a la ubicación para enviar la avería correctamente.";
      } else if (error.code === error.POSITION_UNAVAILABLE) {
        mensaje = "Ubicación no disponible.";
      } else if (error.code === error.TIMEOUT) {
        mensaje = "Tiempo de espera excedido al obtener la ubicación.";
      }

      Swal.fire({
        icon: "warning",
        title: "Ubicación no capturada",
        text: mensaje,
      });

      callback(); // continuar aunque falle
    }
  );
}


$('#btnguardar1').on('click', function (event) {
  event.preventDefault();

  const descripcion = $("#descripcion").val().trim();
  const referencia = $("#referencia").val().trim();
  const celular = $("#celular").val().trim();
  const latitud = $("#latitud").val().trim();
  const longitud = $("#longitud").val().trim();
  const direccion = $("#direccion").val().trim();

  // Validación de campos requeridos
  if (descripcion === "") {
    Swal.fire({
      icon: "warning",
      title: "Campo inválido",
      text: "Por favor, ingresa una descripción.",
    });
    return;
  }
  if (referencia === "") {
    Swal.fire({
      icon: "warning",
      title: "Campo inválido",
      text: "Por favor, ingresa una referencia.",
    });
    return;
  }
  if (celular === "") {
    Swal.fire({
      icon: "warning",
      title: "Campo inválido",
      text: "Por favor, ingresa un número de celular.",
    });
    return;
  }

  // Activar pantalla de carga
  const screen = $('#loader');
  configureLoadingScreen(screen);

  // Verificar si ya hay ubicación
  if (latitud && longitud && direccion) {
    enviarIncidencia(); // Ya hay ubicación, enviar directamente
  } else {
    obtenerUbicacion(() => {
      enviarIncidencia(); // Obtener ubicación antes de enviar
    });
  }

  // Función para enviar el formulario
  function enviarIncidencia() {
    $.ajax({
      url: '../view/enviaraveria.php',
      method: 'POST',
      data: $('#insert_averia').serialize(),
      success: function (data) {
        configureLoadingScreen(screen);

        const respuesta = data.trim();

        if (respuesta === "success") {
          Swal.fire({
            icon: "success",
            title: "¡Incidencia enviada!",
            text: "En breve nos pondremos en contacto con usted. ¡Gracias!",
            confirmButtonText: "Cerrar"
          }).then(() => location.reload());
          $('#descripcion').val("");
        } else if (respuesta === "existe") {
          Swal.fire({
            icon: "info",
            title: "Incidencia ya en proceso",
            text: "Ya existe una incidencia activa para este contrato. Está siendo atendida.",
            confirmButtonText: "Cerrar"
          }).then(() => location.reload());
        } else {
          Swal.fire({
            icon: "error",
            title: "Error",
            text: "Ocurrió un error, por favor registra nuevamente la incidencia.",
            confirmButtonText: "Cerrar"
          }).then(() => location.reload());
        }
      },
      error: function () {
        Swal.fire({
          icon: "error",
          title: "Error AJAX",
          text: "No se pudo contactar con el servidor.",
          confirmButtonText: "Cerrar"
        }).then(() => location.reload());
      }
    });
  }
});

$(function () {
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
      "language": 
    // "http://cdn.datatables.net/plug-ins/1.10.19/i18n/Spanish.json",
    {
        "sProcessing":     "Procesando...",
        "sLengthMenu":     "Mostrar _MENU_ registros",
        "sZeroRecords":    "No se encontraron resultados",
        "sEmptyTable":     "Ningún dato disponible en esta tabla",
        "sInfo":           "Registros del _START_ al _END_ de un total de _TOTAL_ registros",
        "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0 registros",
        "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
        "sInfoPostFix":    "",
        "sSearch":         "Buscar:",
        "sUrl":            "",
        "sInfoThousands":  ",",
        "sLoadingRecords": "Cargando, espere por favor...",
        "oPaginate": {
            "sFirst":    "Primero",
            "sLast":     "Último",
            "sNext":     "Siguiente",
            "sPrevious": "Anterior"
        },
        "oAria": {
            "sSortDescending": ": Activar para ordenar la columna de manera descendente",
            "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
            
        }
        },
    
      "bDestroy":true,
      "iDisplayLength" :4, //Paginacion
      "order":[[0,"desc"]] //Ordenar (columna,orden)
    });
  });
   $(function () {
   
    $('#example3').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
      "language": 
    // "http://cdn.datatables.net/plug-ins/1.10.19/i18n/Spanish.json",
    {

        "sProcessing":     "Procesando...",
        "sLengthMenu":     "Mostrar _MENU_ registros",
        "sZeroRecords":    "No se encontraron resultados",
        "sEmptyTable":     "Ningún dato disponible en esta tabla",
        "sInfo":           "Registros del _START_ al _END_ de un total de _TOTAL_ registros",
        "sInfoEmpty":      "Mostrando registros del 0 al 0 de un total de 0 registros",
        "sInfoFiltered":   "(filtrado de un total de _MAX_ registros)",
        "sInfoPostFix":    "",
        "sSearch":         "Buscar:",
        "sUrl":            "",
        "sInfoThousands":  ",",
        "sLoadingRecords": "Cargando, espere por favor...",
        "oPaginate": {
            "sFirst":    "Primero",
            "sLast":     "Último",
            "sNext":     "Siguiente",
            "sPrevious": "Anterior"
        },
        "oAria": {
            "sSortDescending": ": Activar para ordenar la columna de manera descendente",
            "sSortAscending":  ": Activar para ordenar la columna de manera ascendente",
            
        }
        },
    
      "bDestroy":true,
      "iDisplayLength" :4, //Paginacion
      "order":[[0,"desc"]] //Ordenar (columna,orden)
    });

  });
   function configureLoadingScreen(screen){
    $(document)
         .ajaxStart(function () {
             screen.fadeIn();
         })
        .ajaxStop(function () {
           screen.fadeOut();
         });
    }







  
init();