       // Toggle del menú lateral en móvil
  // 1. Botón de menú móvil
const toggleButton = document.getElementById('menuToggle');
const sidebar = document.getElementById('sidebarMenu');

toggleButton.addEventListener('click', () => {
  sidebar.classList.toggle('active');
});

// 2. Submenú Consultas
const submenuToggle = document.getElementById('toggleSubmenu');
const submenu = document.getElementById('submenuConsultas');
const arrow = document.getElementById('arrowIcon');

submenuToggle.addEventListener('click', function (e) {
  e.preventDefault();
  submenu.classList.toggle('show');
  arrow.classList.toggle('fa-angle-down');
  arrow.classList.toggle('fa-angle-up');
});

// 3. Cerrar menú móvil al hacer clic afuera
document.addEventListener('click', function (e) {
  if (
    !sidebar.contains(e.target) &&
    !toggleButton.contains(e.target) &&
    window.innerWidth <= 767
  ) {
    sidebar.classList.remove('active');
  }
});

// 4. Activar item y cerrar submenú solo si no es submenu o toggleSubmenu
const menuLinks = document.querySelectorAll(".sidebar a");
const submenuLinks = document.querySelectorAll("#submenuConsultas a");

menuLinks.forEach(link => {
  link.addEventListener("click", function () {
    // Si el link clickeado NO es del submenu NI el toggle
    if (
      !this.closest("#submenuConsultas") &&
      this.id !== "toggleSubmenu"
    ) {
      // Cierra el submenú si está abierto
      if (submenu.classList.contains("show")) {
        submenu.classList.remove("show");
        arrow.classList.remove("fa-angle-up");
        arrow.classList.add("fa-angle-down");
      }
    }

    // Manejo de clase activa
    menuLinks.forEach(l => l.classList.remove("active"));
    this.classList.add("active");
  });
});
