$(document).ready(function () {
  // Asociar evento submit al formulario
  $("#frm_registro").on("submit", function (e) {
    guardaryeditar(e);
  });
   
    $("#frm_login").on("submit", function (e) {
    validar_login(e);
  });

});

 
// SweetAlert2 con clases Bootstrap
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2",
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

// Función para guardar y editar
function guardaryeditar(e) {
  e.preventDefault();
  $("#btnGuardar").prop("disabled", true);

  const dni = $("input[name='dni']").val().trim();
  const nombres = $("input[name='nombres']").val().trim();
  const apellidos = $("input[name='apellidos']").val().trim();
  const celular = $("input[name='celular']").val().trim();
  const whatsapp = $("input[name='whatsapp']").val().trim();

  // Validar campos vacíos
  if (!dni || !nombres || !apellidos || !celular || !whatsapp) {
    Swal.fire({
      icon: 'info',
      title: 'Campos obligatorios',
      text: 'Por favor completa todos los campos.',
      confirmButtonText: 'Aceptar'
    });
    $("#btnGuardar").prop("disabled", false);
    return;
  }

  const formData = new FormData($("#frm_registro")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los datos ingresados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Precarga
      Swal.fire({
        title: "Guardando...",
        html: "Por favor espera mientras se procesan los datos.",
        allowOutsideClick: false,
        didOpen: () => {
          Swal.showLoading();
        }
      });

      $.ajax({
        url: "../ajax/persona.php?op=guardar_datos",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (respuesta) {
          try {
            const datos = JSON.parse(respuesta);

            if (datos.status === "success") {
              Swal.fire({
                icon: "success",
                title: "Registro Enviado",
                text: datos.message || "En unos minutos nuestro personal se pondrán en contacto con usted!",
                confirmButtonText: "Aceptar",
                willClose: () => {
                  window.location.href = "portalnew.php";
                }
              });
            } else if (datos.status === "duplicado") {
              Swal.fire({
                icon: "info",
                title: "Registro ya enviado",
                text: datos.message || "Ya hemos recibido su solicitud. En unos minutos se pondrán en contacto con usted!",
                confirmButtonText: "Aceptar",
                willClose: () => {
                  window.location.href = "portalnew.php";
                }
              });
              $("#btnGuardar").prop("disabled", false);
            } else {
              Swal.fire({
                icon: "error",
                title: "Error",
                text: datos.message || "Ocurrió un problema al guardar.",
                timer: 3000,
                timerProgressBar: true
              });
              $("#btnGuardar").prop("disabled", false);
            }
          } catch (error) {
            console.error("Error al parsear respuesta:", error);
            Swal.fire({
              icon: "error",
              title: "Error de respuesta",
              text: "Respuesta inesperada del servidor.",
              confirmButtonText: "Aceptar"
            });
            $("#btnGuardar").prop("disabled", false);
          }
        },
        error: function () {
          Swal.fire({
            icon: "error",
            title: "Error",
            text: "Hubo un problema con la solicitud. Intente nuevamente.",
            confirmButtonText: "Aceptar"
          });
          $("#btnGuardar").prop("disabled", false);
        }
      });

    } else {
      Swal.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "info",
        confirmButtonText: "Aceptar"
      });
      $("#btnGuardar").prop("disabled", false);
    }
  });
}


function validar_login(e) {
  e.preventDefault();
  $("#btnGuardar").prop("disabled", true);

  const numero_documento = $("input[name='numero_documento']").val().trim();
  const password = $("input[name='password']").val().trim();
  const politica = $("#politica").is(":checked");

  // Validaciones
  if (!numero_documento || !password) {
    Swal.fire({
      icon: 'warning',
      title: 'Campos requeridos',
      text: 'Debes ingresar tu número de documento y contraseña.',
      confirmButtonText: 'Aceptar'
    });
    $("#btnGuardar").prop("disabled", false);
    return;
  }

  if (!politica) {
    Swal.fire({
      icon: 'info',
      title: 'Política de privacidad',
      text: 'Debes aceptar las políticas de privacidad antes de continuar.',
      confirmButtonText: 'Aceptar'
    });
    $("#btnGuardar").prop("disabled", false);
    return;
  }

  // Mostrar precarga
  Swal.fire({
    title: "Verificando...",
    html: "Por favor espera...",
    allowOutsideClick: false,
    didOpen: () => {
      Swal.showLoading();
    }
  });

  // Preparar datos
  const formData = new FormData($("#frm_login")[0]);

  // Enviar AJAX
  $.ajax({
    url: "../ajax/persona.php?op=validar_login",
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,
    success: function (respuesta) {
      try {
        const datos = JSON.parse(respuesta);

        if (datos.status === "success") {
          Swal.fire({
            position: 'center',
            title: "Bienvenido",
            text: datos.message || "Credenciales correctas. Redirigiendo al portal.",
            icon: "success",
            timer: 2000,
            timerProgressBar: true,
            allowOutsideClick: false, // Desactiva interacciones externas
            backdrop: false, // Elimina el fondo para evitar el cambio en la altura de la página
            customClass: {
                popup: 'no-margin-swal', // Clase personalizada para ajustar márgenes
            },
            didOpen: () => {
                Swal.showLoading();
            },
            willClose: () => {
                $(location).attr("href", "portalinicio.php");
            }
          });
        } else {
          Swal.fire({
            icon: "error",
            title: "Acceso denegado",
            text: datos.message || "Usuario o contraseña incorrectos.",
            confirmButtonText: "Aceptar"
          });
        }
      } catch (error) {
        console.error("Error al parsear respuesta:", error);
        Swal.fire({
          icon: "error",
          title: "Error de servidor",
          text: "Ocurrió un error inesperado.",
          confirmButtonText: "Aceptar",
          willClose: () => {
              window.location.href = "portalnew.php"; // Reemplaza con tu ruta
            }
        });
      }
    },
    error: function () {
      Swal.fire({
        icon: "error",
        title: "Error de conexión",
        text: "No se pudo contactar al servidor.",
        confirmButtonText: "Aceptar",
        willClose: () => {
              window.location.href = "portalnew.php"; // Reemplaza con tu ruta
            }
      });
    },
    complete: function () {
      $("#btnGuardar").prop("disabled", false);
    }
  });
}

 particlesJS("particles-js", {
        "particles": {
            "number": {
            "value": 80,
            "density": {
                "enable": true,
                "value_area": 800
            }
            },
            "color": {
            "value": "#000000"
            },
            "shape": {
            "type": "circle"
            },
            "opacity": {
            "value": 0.5
            },
            "size": {
            "value": 2
            },
            "line_linked": {
            "enable": true,
            "distance": 150,
            "color": "#000000",
            "opacity": 0.4,
            "width": 1
            },
            "move": {
            "enable": true,
            "speed": 2
            }
        },
        "interactivity": {
            "events": {
            "onhover": {
                "enable": true,
                "mode": "grab"
            }
            }
        },
        "retina_detect": true
        });
