     
     function cargarContratos(tipo_servicio, idpersona) {
        $.ajax({
            url: '../../ajax/contrato.php?op=listar_datos',
            type: 'GET',
            data: {
            idcliente: idpersona,
            tipo_servicio: tipo_servicio // 1 para Internet, 2 para TV
            },
            dataType: 'json',
            success: function (response) {
            let html = '';

            if (response.length === 0) {
                html = `
                <div class="alert alert-danger text-center" role="alert">
                    No cuentas con servicios de ${tipo_servicio == 1 ? 'Internet' : 'TV'} registrados.
                </div>
                `;
            } else {
                response.forEach(c => {
                html += `
                    <div class="mb-4 p-3 border rounded bg-white">
                    <div class="row align-items-center">
                        <div class="col-md-7">
                        <div class="fw-bold">NUMERO CONTRATO: ${c.nrocontrato}</div>
                        <ul class="list-unstyled small mt-2">
                            <li>Tecnología - ${c.tecnologia}</li>    
                            <li>Plan Contratado - ${c.nombre_plan}</li>
                            <li>Fecha Pago - ${c.fechapago} de Mes</li>
                            <li>Mensualidad - ${c.paga}</li>
                            <li>Modalidad - ${c.modalidad}</li>
                        </ul>
                        </div>
                        <div class="col-md-5 text-md-end text-center">
                        <div class="fw-bold">DEUDA TOTAL: S/ ${c.monto_deuda}</div>
                        <div class="text-muted small">Estado Línea - ${c.sit_contrato}</div>
                        <div class="text-muted small">${tipo_servicio == 1 ? 'INTERNET' : 'TV'} - Huancayo</div>
                        </div>
                    </div>
                    <div class="d-flex justify-content-start gap-2 mt-3">
                        <button class="btn btn-outline-info" onclick="modalNuevaOrden('${c.idcontrato}')">
                        Reportar Incidencia
                        </button>
                        <a href="../pagos/pago.php" class="btn btn-danger text-white">Pagar por aquí!</a>
                    </div>
                    </div>`;
                });
            }

            $('#contenedor-contratos').html(html);

            // Actualizar el tab activo visualmente
            $('.tab-custom').removeClass('tab-active').addClass('tab-inactive');
            $(`.tab-custom[data-tipo="${tipo_servicio}"]`).removeClass('tab-inactive').addClass('tab-active');
            },
            error: function (error) {
            console.error('Error al cargar contratos', error);
            }
        });
        }


      const swalWithBootstrapButtons = Swal.mixin({
        customClass: {
            confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
            cancelButton: "btn btn-danger mx-2"
        },
        buttonsStyling: false
        });

      function modalNuevaOrden(idcontrato, situacionContrato) {
        const modal = document.getElementById('modalNuevaOrden');
        // Rellenar los campos del formulario
        document.getElementById('idcontrato').value = idcontrato;
        // Mostrar el modal usando Bootstrap 5
        const modalBootstrap = new bootstrap.Modal(modal);
        modalBootstrap.show();
      }

      function obtenerUbicacion(callback) {
        if (!navigator.geolocation) {
          Swal.fire({
            icon: "error",
            title: "Navegador incompatible",
            text: "Tu navegador no soporta geolocalización.",
          });
          callback(); // continuar sin ubicación
          return;
        }

        navigator.geolocation.getCurrentPosition(
          async function (position) {
            const lat = position.coords.latitude;
            const lon = position.coords.longitude;

            $("#latitud").val(lat);
            $("#longitud").val(lon);

            // Usar Google Maps Geocoding API
            const apiKey = 'AIzaSyBQLjBXPoSFnn0NSj--qoqQUtH2oSlgboA'; // tu API key válida
            const url = `https://maps.googleapis.com/maps/api/geocode/json?latlng=${lat},${lon}&key=${apiKey}`;


            try {
              const response = await fetch(url);
              const data = await response.json();

              if (data.status === "OK" && data.results.length > 0) {
                const direccion = data.results[1].formatted_address;
                $("#direccion").val(direccion);
              } else {
                console.warn("No se pudo obtener la dirección");
                $("#direccion").val("");
              }
            } catch (e) {
              console.error("Error al consultar la dirección:", e);
              $("#direccion").val("");
            }

            callback(); // continuar después de obtener todo
          },
          function (error) {
            let mensaje = "No se pudo obtener tu ubicación.";

            if (error.code === error.PERMISSION_DENIED) {
              mensaje = "Debes permitir el acceso a la ubicación para enviar la avería correctamente.";
            } else if (error.code === error.POSITION_UNAVAILABLE) {
              mensaje = "Ubicación no disponible.";
            } else if (error.code === error.TIMEOUT) {
              mensaje = "Tiempo de espera excedido al obtener la ubicación.";
            }

            Swal.fire({
              icon: "warning",
              title: "Ubicación no capturada",
              text: mensaje,
            });

            callback(); // continuar aunque falle
          }
        );
      }

      $('#btnguardar').on('click', function (event) {
        event.preventDefault();

        const idcontrato = $("#idcontrato").val().trim();
        const tipo_problema = $("#tipo_problema").val().trim();
        const descripcion = $("#descripcion").val().trim();
        const referencia = $("#referencia").val().trim();
        const celular = $("#celular").val().trim();
        const latitud = $("#latitud").val().trim();
        const longitud = $("#longitud").val().trim();
        const direccion = $("#direccion").val().trim();

        // Validación de campos requeridos
          if (tipo_problema === "") {
          Swal.fire({
            icon: "warning",
            title: "Campo inválido",
            text: "Por favor, seleccione el tipo.",
          });
          return;
        }
        if (descripcion === "") {
          Swal.fire({
            icon: "warning",
            title: "Campo inválido",
            text: "Por favor, ingresa una descripción.",
          });
          return;
        }
        if (referencia === "") {
          Swal.fire({
            icon: "warning",
            title: "Campo inválido",
            text: "Por favor, ingresa una referencia.",
          });
          return;
        }
        if (celular === "") {
          Swal.fire({
            icon: "warning",
            title: "Campo inválido",
            text: "Por favor, ingresa un número de celular.",
          });
          return;
        }

        // Activar pantalla de carga
        //const screen = $('#loader');
        //configureLoadingScreen(screen);

        // Verificar si ya hay ubicación
        if (latitud && longitud && direccion) {
          enviarIncidencia(); // Ya hay ubicación, enviar directamente
        } else {
          obtenerUbicacion(() => {
            enviarIncidencia(); // Obtener ubicación antes de enviar
          });
        }

        // Función para enviar el formulario
        function enviarIncidencia() {
          $.ajax({
            url: '../../ajax/servicio.php?op=guardar_incidencia',
            method: 'POST',
            data: $('#insert_averia').serialize(),
            success: function (data) {
              //configureLoadingScreen(screen);

              const respuesta = data.trim();

              if (respuesta === "success") {
                Swal.fire({
                  icon: "success",
                  title: "¡Incidencia enviada!",
                  text: "En breve nos pondremos en contacto con usted. ¡Gracias!",
                  confirmButtonText: "Cerrar"
                }).then(() => location.reload());
                $('#descripcion').val("");
              } else if (respuesta === "existe") {
                Swal.fire({
                  icon: "info",
                  title: "Incidencia ya en proceso",
                  text: "Ya existe una incidencia activa para este contrato. Está siendo atendida.",
                  confirmButtonText: "Cerrar"
                }).then(() => location.reload());
              } else {
                Swal.fire({
                  icon: "error",
                  title: "Error",
                  text: "Ocurrió un error, por favor registra nuevamente la incidencia.",
                  confirmButtonText: "Cerrar"
                }).then(() => location.reload());
              }
            },
            error: function () {
              Swal.fire({
                icon: "error",
                title: "Error AJAX",
                text: "No se pudo contactar con el servidor.",
                confirmButtonText: "Cerrar"
              }).then(() => location.reload());
            }
          });
        }
      });