<?php
ob_start();
session_start();
if (!isset($_SESSION['idusuario'])) {
    // Redirigir si no ha iniciado sesión
    header("Location: portalnew.php");
    exit();
}else{
  require '../header.php';
  $nombre = $_SESSION['nombre'];
  $idpersona = $_SESSION['idusuario'];
}
?>
<style>
  .nav-tabs .nav-item {
    width: 50%;
    text-align: center;
  }


  .tab-btn-custom {
    font-size: 1.1rem;
    font-weight: 600;
    padding: 0.75rem;
    border: 1px solid #dee2e6;
    border-bottom: none;
    background-color: #0d6efd;
    color: #fff;
    transition: none;
    box-shadow: none;
    filter: none;
    opacity: 1;
  }

  .tab-btn-custom:hover {
    background-color: #0d6efd; /* mantiene el mismo color */
    color: #fff;
    box-shadow: none;
    filter: none;
    opacity: 1;
  }

  .tab-btn-custom.active {
    background-color: #fff !important;
    color: #000 !important;
    border-top: 3px solid #0d6efd;
  }

  .custom-table {
    display: flex;
    flex-direction: column;
    width: 100%;
  }

  .custom-table-header,
  .custom-table-row {
    display: flex;
    padding: 12px 15px;
    border-bottom: 1px solid #dee2e6;
  }

  .custom-table-header {
    background-color: #f1f1f1;
    font-weight: bold;
  }

  .custom-table-cell {
    flex: 1;
    padding: 5px;
  }

  /* Responsive: en móviles se apila */
 .custom-table { width: 100%; }
.custom-table-header,
.custom-table-row {
  display: flex;
  border-bottom: 1px solid #ddd;
  padding: 8px 0;
}
.custom-table-cell {
  flex: 1;
  padding: 8px;
}
@media (max-width: 768px) {
  .custom-table-header { display: none; }
  .custom-table-row {
    flex-direction: column;
    border: 1px solid #ddd;
    margin-bottom: 10px;
    border-radius: 6px;
    background: #fff;
    padding: 10px;
  }
  .custom-table-cell {
    display: flex;
    justify-content: space-between;
    padding: 6px 0;
  }
  .custom-table-cell::before {
    content: attr(data-label);
    font-weight: bold;
    color: #555;
  }
}

</style>
    <!-- Sidebar -->
 <!-- Sidebar (oculto por defecto en móvil) -->
    <div class="wrapper d-flex">
        <nav class="sidebar" id="sidebarMenu">
         <h4 class="text-center py-4">
          <img src="https://inntelperu.com/img/logo-gamer.png" alt="Logo Inntel" class="img-fluid" style="max-height: 80px;">
          </h4>
          <hr>
          <a href="../portalinicio.php" ><i class="bi bi-house-door"></i><span class="menu-text"> Inicio </span> </a>
          <a href="../servicios/servicio.php" >
          <i class="bi bi-wallet" style="font-size: 1.5rem;"></i>
          <span class="menu-text">Mis Servicios</span>
          </a>
          <a href="../pagos/pago.php" class="active" id="toggleSubmenu">
            <i class="bi bi-cash"></i> <span class="menu-text">Pagos </span>
            <i id="arrowIcon" class="fas fa-angle-down float-end"></i> 
          </a>
          <div class="submenu" id="submenuConsultas">
            <a href="../pagos/pago.php">Consultar Pago</a>
          </div>
          <a href="../solicitudes/solicitud.php"><i class="bi bi-pencil-square"></i> <span class="menu-text"> Solicitudes </span></a>
          <a href="../datos/dato.php"><i class="bi bi-grid-3x3-gap"></i> <span class="menu-text"> Mi Datos </span></a>
          <hr>
          <a href="../logout.php"><i class="bi bi-box-arrow-right"></i> <span class="menu-text">Cerrar sesión </span></a>
        </nav>

        
        <div class="flex-grow-1 bg-white p-4 shadow-sm rounded" style="min-height: 100vh;">
            <!-- Perfil Superior -->
            <div class="d-flex justify-content-end align-items-center mb-3">
              <div class="text-end">
                <div class="fw-bold">Bienvenido</div>
                <div class="text-success small"><?php echo $nombre ?></div>
                <a href="../datos/dato.php" class="text-decoration-none small">Ver Perfil</a>
              </div>
              <i class="bi bi-person-circle fs-3 ms-2"></i>
            </div>

            <div class="mb-3 text-muted small">
              Pago &gt; <strong>Recibos de Pagos</strong>
            </div>

            <!-- Título -->
            <h5 class="fw-bold mb-4" style="font-size: 1.90rem;" >Pagos Pendiente / Pagados</h5>

            <!-- Box Información de línea -->
            <div class="bg-light rounded border p-3 mb-4">
              <div class="d-flex justify-content-between align-items-center">
                <div>
                  <div class="text-muted small mb-1">LÍNEA CONTROL</div>
                  <h5 class="fw-bold mb-0"><?php echo $nombre ?></h5>
                </div>
                <div class="text-end">
                  <div class="small">Estado: <span class="text-success fw-bold">Activo</span></div>
                </div>
              </div>
            </div>

            <!-- Detalle del plan + Servicios adicionales -->
            <div class="row">
              <div class="col-md-12 mb-4">
                <div class="bg-light rounded border p-3 h-100">

                <div class="col-md-4 mb-4">
                  <label class="form-label">Nro Contrato (*)</label>
                  <select  name="idcontrato" id="idcontrato" class="form-control"   data-live-search="true" data-style="btn-default" >
                  </select>
                </div>

                  <!-- Nav tabs -->
                  <ul class="nav nav-tabs justify-content-center row" id="tabsDeudaPago" role="tablist">
                    <li class="nav-item col-6 text-center" role="presentation">
                      <button class="nav-link tab-btn-custom active w-100" id="deuda-tab" data-bs-toggle="tab" data-bs-target="#deuda" type="button" role="tab" aria-controls="deuda" aria-selected="true">
                        Pendientes
                      </button>
                    </li>
                    <li class="nav-item col-6 text-center" role="presentation">
                      <button class="nav-link tab-btn-custom w-100" id="pago-tab" data-bs-toggle="tab" data-bs-target="#pago" type="button" role="tab" aria-controls="pago" aria-selected="false">
                        Pagados
                      </button>
                    </li>
                  </ul>

                  <!-- Tab panes -->
                  <div class="tab-content p-3 border border-top-0 bg-white">
                    <!-- Detalle de Deuda -->
                    <div class="tab-pane fade show active" id="deuda" role="tabpanel" aria-labelledby="deuda-tab">
                      <div class="custom-table" id="tabla-deudas">
                        <!-- Se insertarán filas con JavaScript -->
                      </div>
                    </div>

                    <!-- Detalle de Pago -->
                     <div class="tab-pane fade show" id="pago" role="tabpanel" aria-labelledby="pago-tab">
                      <div class="custom-table" id="contenedor-pagados"></div>
                    </div>
                  </div>

                </div>
              </div>
            </div>
          </div>
</div>


<div class="modal fade" id="modalPago" tabindex="-1" aria-labelledby="modalPagoLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalPagoLabel">Enviar Voucher</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <form  id="form_voucher"  >
          <input type="hidden" class="form-control" name="idvoucher" id="idvoucher"> 
          <input type="hidden" name="idcuota" id="modal-idcuota">
          <input type="hidden" name="idcontrato" id="modal-idcontrato">
          <div class="mb-3">
              <label>Seleccione Banco: (*)</label>  
            <select type="text" class="form-control  select2" name="idbanco" id="idbanco"   > </select> 
          </div>
          <div class="mb-3">
            <label>Nro Operacion: (*)</label>                                                                   
              <input type="number" class="form-control" name="operacion" id="operacion"  placeholder="Ingrese su Nro Opereacion" >
          </div>
          <div class="mb-3">
              <label>Fecha Pago: (*)</label>                                                                   
              <input type="datetime-local" class="form-control" name="fecha" id="fecha"  >
          </div>
          <div class="mb-3">
            <label>Monto a Pagar: (*)</label>                                                                   
              <input type="number" class="form-control" name="monto" id="modal-monto" readonly="">
          </div>
          <div class="mb-3">
            <label>Imagen Voucher:</label>
              <div style="border: 1px dashed #ccc; padding: 10px; text-align: center; border-radius: 8px;">
              <input type="file" id="imagen" name="imagen" accept="image/*" style="display: none;">
                  <!-- Este es un input oculto para almacenar el nombre de la imagen actual -->
                  <input type="hidden" id="previewImagenPosteHidden" name="previewImagenPoste">

                  <!-- Vista previa de la imagen -->
                  <img id="previewImagenPoste" 
                      src="../../files/imagen.png"
                      alt="Imagen del Voucher"
                      style="cursor: pointer; width: 50%; height: 50%; object-fit: cover; border-radius: 5px;">
              </div>
          </div>
          <!-- Puedes agregar aquí tu botón de "Confirmar Pago" -->
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"> <i class="fas fa-times"></i> Cancelar</button>
            <button type="submit" class="btn btn-primary" id="btnGuardar"> <i class="fas fa-save"></i> Enviar Pago</button>
          </div>
      </form>
    </div>
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<script type="text/javascript" src="../../scripts/principal.js"></script>
<script type="text/javascript" src="../../scripts/pago.js"></script>

<script type="text/javascript">
  document.addEventListener('DOMContentLoaded', function () {
    const idusuario = <?php echo $_SESSION['idusuario']; ?>;
    traerContratos(idusuario);

    // Cuando se seleccione un contrato, cargar deudas y pagos
    $('#idcontrato').on('change', function () {
      const idcontrato = $(this).val();
      if (idcontrato) {
        listarDeudas(idcontrato);
        listarRecibosPagados(idcontrato);
      } else {
        $('#tabla-deudas').html('');
        $('#contenedor-pagados').html('');
      }
    });
  });

</script>
