<?php
ob_start();
session_start();
if (!isset($_SESSION['idusuario'])) {
    // Redirigir si no ha iniciado sesión
    header("Location: portalnew.php");
    exit();
}else{
  $nombre = $_SESSION['nombre'];
  $idpersona = $_SESSION['idusuario'];
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Mi Inntel - Portal</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
  <link rel="stylesheet" href="../static/css/principal.css"/>
</head>
<style>
  #promoCarousel {
    max-width: 100%;
    overflow: hidden;
  }

  .carousel-inner {
    height: 380px; /* Altura fija para todas las imágenes */
    overflow: hidden;
  }

  .carousel-inner .carousel-item {
    height: 100%;
  }

  .carousel-inner img.carrusel-img {
    height: 100%;
    width: 100%;
    object-fit: cover; /* O usa 'contain' si no quieres recortar */
    display: block;
  }

  body {
    overflow-x: hidden;
  }

  
</style>
<body>
<button class="btn btn-custom-green d-md-none m-2" id="menuToggle">
  <i class="fas fa-bars"></i>
</button>
 <!-- Sidebar -->
 <!-- Sidebar (oculto por defecto en móvil) -->
    <div class="wrapper d-flex">
        <nav class="sidebar" id="sidebarMenu">
         <h4 class="text-center py-4">
          <img src="https://inntelperu.com/img/logo-gamer.png" alt="Logo Inntel" class="img-fluid" style="max-height: 80px;">
        </h4>
          <hr>
          <a href="#" class="active"><i class="bi bi-house-door"></i><span class="menu-text"> Inicio </span> </a>
          <a href="servicios/servicio.php">
          <i class="bi bi-wallet" style="font-size: 1.5rem;"></i>
          <span class="menu-text">Mis Servicios</span>
          </a>
          <a href="pagos/pago.php" id="toggleSubmenu">
            <i class="bi bi-cash"></i> <span class="menu-text"> Pagos </span>
            <i id="arrowIcon" class="fas fa-angle-down float-end"></i>
          </a>
          <div class="submenu" id="submenuConsultas">
            <a href="pagos/pago.php">Consultar Pagos</a>
          </div>
          <a href="solicitudes/solicitud.php"><i class="bi bi-pencil-square"></i> <span class="menu-text"> Solicitudes </span></a>
         <a href="datos/dato.php"><i class="bi bi-grid-3x3-gap"></i> <span class="menu-text"> Mi Datos </span></a>
          <hr>
          <a href="logout.php"><i class="bi bi-box-arrow-right"></i> <span class="menu-text">Cerrar sesión </span></a>
        </nav>
        <div class="flex-grow-1 bg-white p-4 shadow-sm rounded" style="min-height: 100vh;">
            <!-- Perfil Superior -->
            <div class="d-flex justify-content-end align-items-center mb-3">
              <div class="text-end">
                <div class="fw-bold">Bienvenido</div>
                <div class="text-success small"><?php echo $nombre ?></div>
                <a href="datos/dato.php" class="text-decoration-none small">Ver Perfil</a>
              </div>
              <i class="bi bi-person-circle fs-3 ms-2"></i>
            </div>
            <!-- Tabs -->
           
            <!-- Breadcrumb -->
            <div class="mb-3 text-muted small">
              Inicio &gt; <strong>Mi Inntel</strong>
            </div>
            <!-- Título -->
            <h5 class="fw-bold mb-4" style="font-size: 1.90rem;" >Mi Inntel</h5>
            <!-- Box Información de línea -->
            <div class="bg-light rounded border p-3 mb-4">
              <div class="d-flex justify-content-between align-items-center">
                <div>
                  <div class="text-muted small mb-1">LÍNEA CONTROL</div>
                  <h5 class="fw-bold mb-0"><?php echo $nombre ?></h5>
                </div>
                <div class="text-end">
                 
                  <div class="small">Estado: <span class="text-success fw-bold">Activo</span></div>
                </div>
              </div>
            </div>
            <!-- Detalle del plan + Servicios adicionales -->
          <div class="row justify-content-center mb-4">
            <div class="col-md-10">
              <div id="promoCarousel" class="carousel slide" data-bs-ride="carousel">
                <div class="carousel-inner" id="carousel-content">
                  <!-- Las imágenes llegan por AJAX -->
                </div>

                <button class="carousel-control-prev" type="button" data-bs-target="#promoCarousel" data-bs-slide="prev">
                  <span class="carousel-control-prev-icon"></span>
                  <span class="visually-hidden">Anterior</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#promoCarousel" data-bs-slide="next">
                  <span class="carousel-control-next-icon"></span>
                  <span class="visually-hidden">Siguiente</span>
                </button>
              </div>
            </div>
          </div>


    </div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<script type="text/javascript" src="../scripts/principal.js"></script>

<script type="text/javascript"> 


$(document).ready(function () {
  $.ajax({
    url: '../ajax/contrato.php?op=listar',
    type: 'GET',
    dataType: 'json',
    success: function (data) {
      let html = '';

      data.forEach((promo, index) => {
        const imgPath = `/template/files/slider/${promo.imagen_url}`;

        if (promo.tipo_imagen === '1') {
          // Solo mostrar en escritorio
          html += `
            <div class="carousel-item ${index === 0 ? 'active' : ''}">
              <img src="${imgPath}" class="d-none d-md-block w-100 rounded carrusel-img" alt="Promoción escritorio">
            </div>`;
        } else if (promo.tipo_imagen === '2') {
          // Solo mostrar en móvil
          html += `
            <div class="carousel-item ${index === 0 ? 'active' : ''}">
              <img src="${imgPath}" class="d-block d-md-none w-100 rounded carrusel-img" alt="Promoción móvil">
            </div>`;
        }
      });

      $('#carousel-content').html(html);
    },
    error: function () {
      $('#carousel-content').html('<div class="text-center text-danger p-4">Error al cargar promociones.</div>');
    }
  });
});






</script>