<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Mi Inntel - Portal</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@300;700&display=swap" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/particles.js@2.0.0/particles.min.js"></script>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
  <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <link rel="stylesheet" href="../static/css/portal.css"/>
</head>
<body>
     <div class="page-wrapper">
        <div class="container-fluid main-container">
          <div class="row justify-content-center w-100">
            <div class="col-lg-6 left-panel d-flex flex-column align-items-center text-center">
              <h1>Mi Portal Inntel</h1>
              <p>Bienvenido al Portal Inntel Virtual. Aquí puedes realizar la consulta de tu pagos, el registro de incidencia  de manera sencilla y segura.</p>
              <img src="https://mesapartesvirtual.jne.gob.pe/dist/assets/imgs/img-mesa.svg" alt="Portal Inntel">
            </div>

          <div class="col-lg-5 d-flex align-items-center justify-content-center">
              <div class="login-card">
                <img src="../files/logo.png" alt="INNTEL Logo" class="logo">
                <h2>Web Mi Inntel</h2>
                <form class="form" method="post"  id="frm_login" autocomplete="off">
                  <div class="mb-3">
                    <label class="form-label">Usuario (DNI)/RUC</label>
                    <input type="number" name="numero_documento" id="numero_documento"  class="form-control" placeholder="DNI/RUC">
                  </div>
                  <div class="mb-3 position-relative">
                    <label class="form-label">Contraseña</label>
                    <input type="password" class="form-control" name="password" id="password" placeholder="Contraseña">
                    <span id="togglePassword" style="position:absolute; right:10px; top:38px; cursor:pointer;">👁️</span>
                  </div>
                  <!-- <div class="mb-3">
                    <label class="form-label">Código</label>
                    <input type="text" class="form-control mb-2" placeholder="Ingrese código">
                    
                    <button type="button" class="btn btn-link p-0 mt-1">🔄 Recargar</button>
                  </div> -->
                  <div class="form-check mb-3">
                    <input class="form-check-input" type="checkbox" id="politica">
                    <label class="form-check-label" for="politica">Aceptar políticas de privacidad</label>
                  </div>
                  <button type="submit" id="btnGuardar" class="btn btn-danger w-100">INGRESAR</button>
                  </form>
                  <div class="links mt-3 text-center">
                      <p class="mb-1">¿No tienes cuenta? <a href="portalregistro.php">Registrarse</a></p>
                     <p class="mb-1">
                      <a href="#" data-bs-toggle="modal" data-bs-target="#modalRecuperarClave">Recuperar clave</a>
                    </p>
                     
                  </div>
              </div>
            </div>
          </div>
          </div>
        <footer class="site-footer text-center">
          <div class="container">
            <p>&copy; 2025 Mi Portal Inntel. Todos los derechos reservados.</p>
            <p>Desarrollado por el equipo de Tecnología Inntel</p>
          </div>
        </footer>
      </div>
  <div id="particles-js"></div>
  <div class="modal fade" id="modalPolitica" tabindex="-1" aria-labelledby="modalPoliticaLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalPoliticaLabel">Política de Privacidad</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <p>
          Aquí va el contenido completo de tu política de privacidad. Puedes colocar texto, listas, o incluso enlaces.
        </p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>
<!-- Modal de Recuperar Clave -->
<div class="modal fade" id="modalRecuperarClave" tabindex="-1" aria-labelledby="modalRecuperarClaveLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content border-0 shadow">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title" id="modalRecuperarClaveLabel"><i class="bi bi-shield-lock"></i> Recuperar clave</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <p class="mb-0">Por favor, si desea recuperar su clave comuníquese con soporte al número <strong>064 460016</strong>.</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

</body>
</html>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script type="text/javascript" src="../scripts/registro.js"></script>
<script>
         document.getElementById("togglePassword").addEventListener("click", function () {
          const passwordInput = document.getElementById("password");
          const isPassword = passwordInput.type === "password";

          passwordInput.type = isPassword ? "text" : "password";
          this.textContent = isPassword ? "👁️" : "👁️"; // Cambia el ícono si deseas
        });

        document.getElementById('politica').addEventListener('change', function () {
    if (this.checked) {
      const politicaModal = new bootstrap.Modal(document.getElementById('modalPolitica'));
      politicaModal.show();
    }
  });
</script>
