<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Mi Inntel - Portal</title>
<!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@300;700&display=swap" rel="stylesheet">
  <!-- Particles.js -->
  <script src="https://cdn.jsdelivr.net/npm/particles.js@2.0.0/particles.min.js"></script>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
  <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
   <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <link rel="stylesheet" href="../static/css/portal.css"/>
 
</head>
<body>
    <div class="page-wrapper">
      <div class="container-fluid main-container">
        <div class="row justify-content-center w-100">
          <div class="col-lg-6 left-panel d-flex flex-column align-items-center text-center">
            <h1>Mi Portal Inntel</h1>
            <p>Bienvenido al Portal Inntel Virtual. Aquí puedes realizar la consulta de tu pagos, el registro de incidencia  de manera sencilla y segura.</p>
            <img src="https://mesapartesvirtual.jne.gob.pe/dist/assets/imgs/img-mesa.svg" alt="Portal Inntel">
          </div>

        <div class="col-lg-5 d-flex align-items-center justify-content-center">
            <div class="login-card">
              <img src="../files/logo.png" alt="INNTEL Logo" class="logo">
              <h2>Registre sus Datos</h2>
                <form class="form" method="post"  id="frm_registro" autocomplete="off">
                 <input type="hidden" name="idpersona">
                <div class="mb-3">
                  <label class="form-label">(DNI)/(RUC)</label>
                  <input type="number" name="dni" class="form-control" placeholder="DNI">
                </div>
                <div class="mb-3">
                  <label class="form-label">Nombres</label>
                  <input type="text" name="nombres" class="form-control" placeholder="Nombres">
                </div>
                <div class="mb-3">
                  <label class="form-label">Apellidos</label>
                  <input type="text" name="apellidos" class="form-control" placeholder="Apellidos">
                </div>
                <div class="mb-3">
                  <label class="form-label">Celular1</label>
                 <input type="text" name="celular" class="form-control" placeholder="Número de celular"
                        pattern="\d{9}" maxlength="9" minlength="9" 
                        title="Debe ingresar 9 dígitos numéricos">
                  </div>
                <div class="mb-3">
                  <label class="form-label">WhatsApp</label>
                   <input type="text" name="whatsapp" class="form-control" placeholder="Número de WhatsApp"
                      pattern="\d{9}" maxlength="9" minlength="9" 
                      title="Debe ingresar exactamente 9 dígitos numéricos">
                </div>
              <button type="submit" id="btnGuardar" class="btn btn-danger w-100">REGISTRAR</button>
                </form>
                <div class="links mt-3 text-center">
                    <p class="mb-1">Ya tienes cuenta ?<a href="portalnew.php">Ingresar</a></p>
                     <p class="mb-1">
                      <a href="#" data-bs-toggle="modal" data-bs-target="#modalRecuperarClave">Recuperar clave</a>
                    </p>
                    
                </div>
            </div>
          </div>
        </div>
      </div>
      <footer class="site-footer text-center">
        <div class="container">
          <p>&copy; 2025 Mi Portal Inntel. Todos los derechos reservados.</p>
          <p>Desarrollado por el equipo de Tecnología Inntel</p>
        </div>
      </footer>
    </div>
    
  <div id="particles-js"></div>
  <!-- Modal de Recuperar Clave -->
<div class="modal fade" id="modalRecuperarClave" tabindex="-1" aria-labelledby="modalRecuperarClaveLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content border-0 shadow">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title" id="modalRecuperarClaveLabel"><i class="bi bi-shield-lock"></i> Recuperar clave</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <p class="mb-0">Por favor, si desea recuperar su clave comuníquese con soporte al número <strong>064 460016</strong>.</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>
  </body>
</html>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <script type="text/javascript" src="../scripts/registro.js"></script>
 <script type="text/javascript">
   const limitarNumeros = (input) => {
    input.addEventListener('input', function () {
      this.value = this.value.replace(/\D/g, '').slice(0, 9); // solo números y máx 9
    });
  };

  document.addEventListener('DOMContentLoaded', function () {
    limitarNumeros(document.querySelector('input[name="celular"]'));
    limitarNumeros(document.querySelector('input[name="whatsapp"]'));
  });
</script>

