<?php
ob_start();
session_start();
if (!isset($_SESSION['idusuario'])) {
    // Redirigir si no ha iniciado sesión
    header("Location: portalnew.php");
    exit();
}else{
  require '../header.php';
  $nombre = $_SESSION['nombre'];
  $idpersona = $_SESSION['idusuario'];
}
?>
 <!-- Sidebar -->
 <!-- Sidebar (oculto por defecto en móvil) -->
    <div class="wrapper d-flex">
        <nav class="sidebar" id="sidebarMenu">
         <h4 class="text-center py-4">
          <img src="https://inntelperu.com/img/logo-gamer.png" alt="Logo Inntel" class="img-fluid" style="max-height: 80px;">
        </h4>
          <hr>
          <a href="../portalinicio.php" ><i class="bi bi-house-door"></i><span class="menu-text"> Inicio </span> </a>
          <a href="../servicios/servicio.php" class="active">
          <i class="bi bi-wallet" style="font-size: 1.5rem;"></i>
          <span class="menu-text">Mis Servicios</span>
          </a>
          <a href="../pagos/pago.php" id="toggleSubmenu">
            <i class="bi bi-cash"></i> <span class="menu-text">Pagos </span>
            <i id="arrowIcon" class="fas fa-angle-down float-end"></i>
          </a>
          <div class="submenu" id="submenuConsultas">
            <a href="../pagos/pago.php">Consultar Pagos</a>
          </div>
          <a href="../solicitudes/solicitud.php"><i class="bi bi-pencil-square"></i> <span class="menu-text"> Solicitudes </span></a>
          <a href="../datos/dato.php"><i class="bi bi-grid-3x3-gap"></i> <span class="menu-text"> Mi Datos </span></a>
          <hr>
          <a href="../logout.php"><i class="bi bi-box-arrow-right"></i> <span class="menu-text">Cerrar sesión </span></a>
        </nav>
        <div class="flex-grow-1 bg-white p-4 shadow-sm rounded" style="min-height: 100vh;">
            <!-- Perfil Superior -->
            <div class="d-flex justify-content-end align-items-center mb-3">
              <div class="text-end">
                <div class="fw-bold">Bienvenido</div>
                <div class="text-success small"><?php echo $nombre ?></div>
                <a href="../datos/dato.php" class="text-decoration-none small">Ver Perfil</a>
              </div>
              <i class="bi bi-person-circle fs-3 ms-2"></i>
            </div>
            <!-- Tabs -->
           <div class="d-flex border-bottom mb-3 gap-2">
              <div class="flex-fill text-center fw-bold tab-custom tab-active" data-tipo="1" onclick="cargarContratos(1, <?php echo $idpersona; ?>)">
                <i class="bi bi-router"></i> Internet
              </div>
              <div class="flex-fill text-center fw-bold tab-custom tab-inactive" data-tipo="2" onclick="cargarContratos(2, <?php echo $idpersona; ?>)">
                <i class="bi bi-tv"></i> TV
              </div>
            </div>
            <!-- Breadcrumb -->
            <div class="mb-3 text-muted small">
              Servicio &gt; <strong>Servicios Contratados</strong>
            </div>
            <!-- Título -->
            <h5 class="fw-bold mb-4" style="font-size: 1.90rem;" >Servicios Contratados</h5>
            <!-- Box Información de línea -->
            <div class="bg-light rounded border p-3 mb-4">
              <div class="d-flex justify-content-between align-items-center">
                <div>
                  <div class="text-muted small mb-1">LÍNEA CONTROL</div>
                  <h5 class="fw-bold mb-0"><?php echo $nombre ?></h5>
                </div>
                <div class="text-end">
                  <!-- <div class="small">Fecha de Activación: <strong>12-12-2024</strong></div> -->
                  <div class="small">Estado: <span class="text-success fw-bold">Activo</span></div>
                </div>
              </div>
            </div>
            <!-- Detalle del plan + Servicios adicionales -->
            <div class="row">
              <!-- Detalle del plan -->
              <div class="col-md-12 mb-4">
                  <div class="bg-light rounded border p-3 h-100">
                    <div class="fw-bold mb-2 border-bottom pb-1">Detalle de los Contratos</div>
                    <div id="contenedor-contratos"></div>
                  </div>
                </div>
            </div>
        </div>
</div>
      <!-- Modal Nueva Orden -->
      <div class="modal fade" id="modalNuevaOrden" tabindex="-1" aria-labelledby="modalNuevaOrdenLabel" aria-hidden="true">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="modalNuevaOrdenLabel">Registrar Nueva Orden</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <form  id="insert_averia"   method="post">
                <input  type="hidden" name="idcontrato" id="idcontrato" class="form-control"   data-live-search="true" data-style="btn-default" >
                  </input>
                <div class="mb-3">
                  <label class="form-label">Tipo Problema (*)</label>
                  <select  name="tipo_problema" id="tipo_problema" class="form-control"   data-live-search="true"  >
                    <option value="">Seleccione Problema</option>
                    <option value="1">Internet</option>
                    <option value="2">Facturacion</option>
                    <option value="2">Otros</option>
                  </select>
                </div>
                <div class="mb-3">
                  <label class="form-label">Descripción del Problema (*)</label>
                  <textarea class="form-control" name="descripcion" id="descripcion" required  placeholder="Descripcion ..."></textarea>
                </div>
                <div class="mb-3">
                  <label class="form-label">Referencia de Dirección (*)</label>
                  <input type="text" class="form-control" name="referencia" id="referencia" placeholder="Referencia direccion ..." required>
                </div>
                <div class="mb-3">
                  <label class="form-label">Número de Contacto (*)</label>
                  <input type="text" class="form-control" name="celular" id="celular" placeholder="Numero de Contacto" required>
                </div>
                <input type="hidden" name="latitud" id="latitud">
                <input type="hidden" name="longitud" id="longitud">
                <input type="hidden" name="direccion" id="direccion">
              
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"> <i class="fas fa-times"></i> Cancelar</button>
                <button  id="btnguardar" class="btn btn-success"> <i class="fas fa-save"></i> Enviar Orden</button>
              </div>
            </form>
          </div>
        </div>
      </div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<script type="text/javascript" src="../../scripts/principal.js"></script>
<script type="text/javascript" src="../../scripts/servicio.js"></script>
<script>
  document.addEventListener('DOMContentLoaded', function () {
    const idpersona = <?php echo json_encode($idpersona); ?>;
    cargarContratos(1, idpersona);
  });
</script>
