<?php
ob_start();
session_start();
if (!isset($_SESSION['idusuario'])) {
    // Redirigir si no ha iniciado sesión
    header("Location: portalnew.php");
    exit();
}else{
  require '../header.php';
  $nombre = $_SESSION['nombre'];
  $idpersona = $_SESSION['idusuario'];
}
?>
<style>
   .custom-table {
  display: flex;
  flex-direction: column;
  width: 100%;
}

.custom-table-header,
.custom-table-row {
  display: flex;
  padding: 12px 15px;
  border-bottom: 1px solid #dee2e6;
  flex-wrap: wrap;
}

.custom-table-header {
  background-color: #f1f1f1;
  font-weight: bold;
}

.custom-table-cell {
  flex: 1;
  padding: 5px;
  word-wrap: break-word;
  word-break: break-word;
}

/* Responsive */
@media (max-width: 768px) {
  .custom-table-header {
    display: none;
  }

  .custom-table-row {
    flex-direction: column;
    border: 1px solid #ddd;
    margin-bottom: 10px;
    border-radius: 6px;
    background: #fff;
    padding: 10px;
  }

  .custom-table-cell {
    display: flex;
    justify-content: space-between;
    padding: 6px 0;
  }

  .custom-table-cell::before {
    content: attr(data-label);
    font-weight: bold;
    color: #555;
    margin-right: 10px;
  }
}
</style>
    <!-- Sidebar -->
 <!-- Sidebar (oculto por defecto en móvil) -->
    <div class="wrapper d-flex">
        <nav class="sidebar" id="sidebarMenu">
         <h4 class="text-center py-4">
          <img src="https://inntelperu.com/img/logo-gamer.png" alt="Logo Inntel" class="img-fluid" style="max-height: 80px;">
        </h4>
          <hr>
          <a href="../portalinicio.php" ><i class="bi bi-house-door"></i><span class="menu-text"> Inicio </span> </a>
          <a href="../servicios/servicio.php" >
          <i class="bi bi-wallet" style="font-size: 1.5rem;"></i>
          <span class="menu-text">Mis Servicios</span>
          </a>
          <a href="../pagos/pago.php" id="toggleSubmenu">
            <i class="bi bi-cash"></i> <span class="menu-text">Pagos </span>
            <i id="arrowIcon" class="fas fa-angle-down float-end"></i>
          </a>
          <div class="submenu" id="submenuConsultas">
            <a href="../pagos/pago.php">Consultar Pagos</a>
          
          </div>
          <a href="../solicitudes/solicitud.php" class="active" ><i class="bi bi-pencil-square"></i> <span class="menu-text"> Orden de Servicio </span></a>
          <a href="../datos/dato.php"><i class="bi bi-grid-3x3-gap"></i> <span class="menu-text"> Mi Datos </span></a>
          <hr>
          <a href="../logout.php"><i class="bi bi-box-arrow-right"></i> <span class="menu-text">Cerrar sesión </span></a>
        </nav>

        
          <div class="flex-grow-1 bg-white p-4 shadow-sm rounded" style="min-height: 100vh;">
            <!-- Perfil Superior -->
            <div class="d-flex justify-content-end align-items-center mb-3">
              <div class="text-end">
                <div class="fw-bold">Bienvenido</div>
                <div class="text-success small"><?php echo $nombre ?></div>
                <a href="../datos/dato.php" class="text-decoration-none small">Ver Perfil</a>
              </div>
              <i class="bi bi-person-circle fs-3 ms-2"></i>
            </div>

            <!-- Breadcrumb -->
            <div class="mb-3 text-muted small">
              Ordenes &gt; <strong>Orden de Servicio Tecnico</strong>
            </div>
            <!-- Título -->
            <h5 class="fw-bold mb-4" style="font-size: 1.90rem;" >Orden de Servicio Tecnico</h5>
            <div class="mb-3 text-muted small">
              Conoce el estado de las averias registradas 
            </div>

               <div class="text-end mb-3">
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalNuevaOrden">
                  <i class="bi bi-plus-circle"></i> Registrar Nueva Orden
                </button>
              </div>

             <!-- Estados -->
              <div class="row text-center mb-4">
                <div class="col-md-3 col-6 mb-3">
                  <div class="border rounded py-4 px-2 shadow-sm">
                    <i class="bi bi-hourglass-split fs-3"></i><br>
                    <span class="fw-semibold">Esperando Aprobación</span>
                  </div>
                </div>
                <div class="col-md-3 col-6 mb-3">
                  <div class="border rounded py-4 px-2 shadow-sm">
                    <i class="bi bi-truck fs-3"></i><br>
                    <span class="fw-semibold">Cuadrila en camino al Centro de Atención</span>
                  </div>
                </div>
                <div class="col-md-3 col-6 mb-3">
                  <div class="border rounded py-4 px-2 shadow-sm">
                    <i class="bi bi-tools fs-3"></i><br>
                    <span class="fw-semibold">En proceso del problema </span>
                  </div>
                </div>
                <div class="col-md-3 col-6 mb-3">
                  <div class="border rounded py-4 px-2 shadow-sm">
                    <i class="bi bi-check-circle fs-3"></i><br>
                    <span class="fw-semibold">Atencion Culminada</span>
                  </div>
                </div>
              </div>
            
                <div class="row">
                  <div class="col-md-12">
                    <div class="bg-light rounded border p-3 h-100">
                      <div class="custom-table"> <!-- Este contenedor es clave -->
                        <!-- Cabecera -->
                        <div class="custom-table-header">
                          <div class="custom-table-cell">ESTADO DE ORDEN</div>
                          <div class="custom-table-cell">TICKET ORDEN</div>
                          <div class="custom-table-cell">NRO DE CONTRATO</div>
                          <div class="custom-table-cell">FECHA DE REGISTRO</div>
                          <div class="custom-table-cell">TECNICO RESPONSABLE</div>
                        </div>

                        <!-- Fila dinámica con datos -->
                        
                        <!-- Fin fila -->
                      </div>
                    </div>
                  </div>
                </div>
         </div>
</div>

<!-- Modal Nueva Orden -->
<div class="modal fade" id="modalNuevaOrden" tabindex="-1" aria-labelledby="modalNuevaOrdenLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalNuevaOrdenLabel">Registrar Nueva Orden</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form  id="insert_averia" method="post">
          <div class="mb-3">
            <label class="form-label">Tipo Problema (*)</label>
            <select  name="tipo_problema" id="tipo_problema" class="form-control"   data-live-search="true" data-style="btn-default" >
              <option value="">Seleccione Problema</option>
              <option value="1">Internet</option>
              <option value="2">Facturacion</option>
              <option value="2">Otros</option>
            </select>
          </div>
          <div class="mb-3">
            <label class="form-label">Nro Contrato (*)</label>
            <select  name="idcontrato" id="idcontrato" class="form-control"   data-live-search="true" data-style="btn-default" >
            </select>
          </div>
          <div class="mb-3">
            <label class="form-label">Descripción del Problema (*)</label>
            <textarea class="form-control" name="descripcion" id="descripcion" required  placeholder="Descripcion ..."></textarea>
          </div>
          <div class="mb-3">
            <label class="form-label">Referencia de Dirección (*)</label>
            <input type="text" class="form-control" name="referencia" id="referencia" placeholder="Referencia direccion ..." required>
          </div>
          <div class="mb-3">
            <label class="form-label">Número de Contacto (*)</label>
            <input type="text" class="form-control" name="celular" id="celular" placeholder="Numero de Contacto" required>
          </div>
          <input type="hidden" name="latitud" id="latitud">
                <input type="hidden" name="longitud" id="longitud">
                <input type="hidden" name="direccion" id="direccion">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"> <i class="fas fa-times"></i> Cancelar</button>
        <button id="btnguardar" class="btn btn-success"> <i class="fas fa-save"></i> Enviar Orden</button>
      </div>
      </form>
    </div>
  </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<script type="text/javascript" src="../../scripts/principal.js"></script>

<script type="text/javascript">
 
  document.addEventListener('DOMContentLoaded', function () {
    listarOrdenes(<?php echo $_SESSION['idusuario']; ?>);
    traerContratos(<?php echo $_SESSION['idusuario']; ?>);
  });

  function listarOrdenes(idcliente) {
  $.ajax({
    url: '../../ajax/servicio.php?op=listar_ordenes',
    method: 'GET',
    data: { idcliente: idcliente },
    dataType: 'json',
    success: function (response) {
      let html = '';

      if (response.length === 0) {
        html = `<div class="alert alert-info text-center">No se encontraron órdenes registradas.</div>`;
      } else {
        response.forEach(o => {
          html += `
            <div class="custom-table-row">
              <div class="custom-table-cell" data-label="Estado de Orden">
              ${generarBadgeEstado(o.estado)}
              </div>
              <div class="custom-table-cell" data-label="Ticket Orden">${generarTicket(o.fecha, o.idincidencia)}</div>
              <div class="custom-table-cell" data-label="Nro de Contrato">${o.nrocontrato}</div>
              <div class="custom-table-cell" data-label="Fecha de Registro">${o.fecha}</div>
              <div class="custom-table-cell" data-label="Tecnico Responsable">${o.tecnico}
              </div>
            </div>`;
        });
      }

      $('.custom-table').append(html); // o reemplaza si quieres con `.html(html)`
    },
    error: function (xhr) {
      console.error('Error al cargar órdenes:', xhr);
    }
  });
}

function generarBadgeEstado(estado) {
  switch (estado) {
    case '1':
      return `<span class="badge bg-primary">
                <i class="bi bi-hourglass-split"></i> Cuadrilla Asignada
              </span>`;
    case '2':
      return `<span class="badge bg-warning text-dark">
                <i class="bi bi-truck"></i> Cuadrilla en camino
              </span>`;
    case '3':
      return `<span class="badge bg-success">
                <i class="bi bi-check-circle"></i> Atención Culminada
              </span>`;
    default:
      return `<span class="badge bg-danger">
                <i class="bi bi-hourglass-split"></i> Esperando Aprobación
              </span>`;
  }
}

function generarTicket(fecha, idincidencia) {
  const [anio, mes] = fecha.split('-'); // formato 'YYYY-MM-DD'
  return `${anio}${mes}-${String(idincidencia).padStart(4, '0')}`;
}
function traerContratos(idusuario) {
  $.post("../../ajax/contrato.php?op=selectContrato", { idusuario: idusuario }, function (r) {
    // Limpiar las opciones antes de agregar nuevas
    $("#idcontrato").html('<option value="">Seleccione un Contrato</option>');

    // Agregar nuevas opciones
    $("#idcontrato").append(r);
  });
}

 const swalWithBootstrapButtons = Swal.mixin({
        customClass: {
            confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
            cancelButton: "btn btn-danger mx-2"
        },
        buttonsStyling: false
        });

        function obtenerUbicacion(callback) {
        if (!navigator.geolocation) {
          Swal.fire({
            icon: "error",
            title: "Navegador incompatible",
            text: "Tu navegador no soporta geolocalización.",
          });
          callback(); // continuar sin ubicación
          return;
        }

        navigator.geolocation.getCurrentPosition(
          async function (position) {
            const lat = position.coords.latitude;
            const lon = position.coords.longitude;

            $("#latitud").val(lat);
            $("#longitud").val(lon);

            // Usar Google Maps Geocoding API
            const apiKey = 'AIzaSyBQLjBXPoSFnn0NSj--qoqQUtH2oSlgboA'; // tu API key válida
            const url = `https://maps.googleapis.com/maps/api/geocode/json?latlng=${lat},${lon}&key=${apiKey}`;


            try {
              const response = await fetch(url);
              const data = await response.json();

              if (data.status === "OK" && data.results.length > 0) {
                const direccion = data.results[1].formatted_address;
                $("#direccion").val(direccion);
              } else {
                console.warn("No se pudo obtener la dirección");
                $("#direccion").val("");
              }
            } catch (e) {
              console.error("Error al consultar la dirección:", e);
              $("#direccion").val("");
            }

            callback(); // continuar después de obtener todo
          },
          function (error) {
            let mensaje = "No se pudo obtener tu ubicación.";

            if (error.code === error.PERMISSION_DENIED) {
              mensaje = "Debes permitir el acceso a la ubicación para enviar la avería correctamente.";
            } else if (error.code === error.POSITION_UNAVAILABLE) {
              mensaje = "Ubicación no disponible.";
            } else if (error.code === error.TIMEOUT) {
              mensaje = "Tiempo de espera excedido al obtener la ubicación.";
            }

            Swal.fire({
              icon: "warning",
              title: "Ubicación no capturada",
              text: mensaje,
            });

            callback(); // continuar aunque falle
          }
        );
      }

      $('#btnguardar').on('click', function (event) {
        event.preventDefault();

        const idcontrato = $("#idcontrato").val().trim();
        const tipo_problema = $("#tipo_problema").val().trim();
        const descripcion = $("#descripcion").val().trim();
        const referencia = $("#referencia").val().trim();
        const celular = $("#celular").val().trim();
        const latitud = $("#latitud").val().trim();
        const longitud = $("#longitud").val().trim();
        const direccion = $("#direccion").val().trim();

        // Validación de campos requeridos
        
          if (tipo_problema === "") {
          Swal.fire({
            icon: "warning",
            title: "Campo inválido",
            text: "Por favor, seleccione el tipo.",
          });
          return;
        }
          if (idcontrato === "") {
          Swal.fire({
            icon: "warning",
            title: "Campo inválido",
            text: "Por favor, seleccione un contrato.",
          });
          return;
        }
        if (descripcion === "") {
          Swal.fire({
            icon: "warning",
            title: "Campo inválido",
            text: "Por favor, ingresa una descripción.",
          });
          return;
        }
        if (referencia === "") {
          Swal.fire({
            icon: "warning",
            title: "Campo inválido",
            text: "Por favor, ingresa una referencia.",
          });
          return;
        }
        if (celular === "") {
          Swal.fire({
            icon: "warning",
            title: "Campo inválido",
            text: "Por favor, ingresa un número de celular.",
          });
          return;
        }

        // Activar pantalla de carga
        //const screen = $('#loader');
        //configureLoadingScreen(screen);

        // Verificar si ya hay ubicación
        if (latitud && longitud && direccion) {
          enviarIncidencia(); // Ya hay ubicación, enviar directamente
        } else {
          obtenerUbicacion(() => {
            enviarIncidencia(); // Obtener ubicación antes de enviar
          });
        }

        // Función para enviar el formulario
        function enviarIncidencia() {
          $.ajax({
            url: '../../ajax/servicio.php?op=guardar_incidencia',
            method: 'POST',
            data: $('#insert_averia').serialize(),
            success: function (data) {
              //configureLoadingScreen(screen);

              const respuesta = data.trim();

              if (respuesta === "success") {
                Swal.fire({
                  icon: "success",
                  title: "¡Incidencia enviada!",
                  text: "En breve nos pondremos en contacto con usted. ¡Gracias!",
                  confirmButtonText: "Cerrar"
                }).then(() => location.reload());
                $('#descripcion').val("");
              } else if (respuesta === "existe") {
                Swal.fire({
                  icon: "info",
                  title: "Incidencia ya en proceso",
                  text: "Ya existe una incidencia activa para este contrato. Está siendo atendida.",
                  confirmButtonText: "Cerrar"
                }).then(() => location.reload());
              } else {
                Swal.fire({
                  icon: "error",
                  title: "Error",
                  text: "Ocurrió un error, por favor registra nuevamente la incidencia.",
                  confirmButtonText: "Cerrar"
                }).then(() => location.reload());
              }
            },
            error: function () {
              Swal.fire({
                icon: "error",
                title: "Error AJAX",
                text: "No se pudo contactar con el servidor.",
                confirmButtonText: "Cerrar"
              }).then(() => location.reload());
            }
          });
        }
      });

</script>